////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define WIN32_LEAN_AND_MEAN

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <ShlOBJ.H>
#include <PrSht.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <WinSock2.H>
#include <WinSock.H>

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "Headers/NASCCL.H"
#include "Headers/NSWFL.H"

#include "Resources/Resource.H"

#include "SQLClass/Definitions.H"
#include "SQLClass/Functions.H"

#include "TCP/Definitions.H"
#include "Headers/CRC.H"
#include "Headers/Definitions.H"
#include "Headers/Security.H"
#include "Headers/Service.H"

#include "Headers/ClientInfo.H"

#include "TCP/Class.H"

#include "Headers/Commands.H"
#include "Headers/Authenticate.H"
#include "Headers/Functions.H"

#include "Dialogs/TabGeneral.H"
#include "Dialogs/TabAccounts.H"
#include "Dialogs/TabSecurity.H"
#include "Dialogs/TabAdvanced.H"
#include "Dialogs/Server.H"

#include "Headers/Init.H"

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	int Length		   = 0;
	short Result	   = 0;
	LONG LastError     = 0;
    HANDLE MutexHandle = NULL;

	MainInstance = hInstance;

    if(!Initialize())
        return false;

    StartServer();
	DialogBox(MainInstance, MAKEINTRESOURCE(IDD_SERVER), 0, ServerDialog);
    StopServer();

/*
    if( IsWinNT() != true)
    {
        MessageBox(NULL, "This application was designed to run only on NT based systems.", TitleCaption, MB_SYSTEMMODAL + MB_TASKMODAL);
        return 0;
    }

    //-------------------------------------------------------------------------------

    SECURITY_DESCRIPTOR SD;
   	SECURITY_ATTRIBUTES SA;

   	if(InitializeSecurityDescriptor(&SD, SECURITY_DESCRIPTOR_REVISION) == FALSE)
   		return FALSE;

   	if(SetSecurityDescriptorDacl(&SD, TRUE, 0, FALSE) == FALSE)
   		return FALSE;

   	SA.nLength				= sizeof(SA);
   	SA.lpSecurityDescriptor = &SD;
   	SA.bInheritHandle		= FALSE;
    MutexHandle = CreateMutex(&SA, FALSE, TitleCaption);

	LastError = GetLastError();
	if(MutexHandle != 0)
	{
		if(LastError == ERROR_ALREADY_EXISTS)
        {
			MessageBox(NULL, "Application already running.", TitleCaption, MB_SYSTEMMODAL + MB_TASKMODAL);
			return 0;
		}
	}

    //-------------------------------------------------------------------------------

	Result = xServiceEntry(szCmdLine);

	if(Result == _Success_)
    {
    	ReleaseMutex(MutexHandle);
    	CloseHandle(MutexHandle);

        return(_Success_);
    }
	else if(Result == _Error_)
    {
    	ReleaseMutex(MutexHandle);
    	CloseHandle(MutexHandle);

        return(_Error_);
    }

    //-------------------------------------------------------------------------------
*/
    return 0;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

